/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlFetcher {
    public static Document fetchXmlFromUrl(String urlString) {
        System.out.println("Fetching XML from URL: " + urlString);
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            InputStream inputStream = connection.getInputStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inputStream);
            inputStream.close();
            System.out.println("XML fetched successfully.");
            return doc;
        }
        catch (Exception e) {
            System.out.println("Error fetching XML.");
            e.printStackTrace();
            return null;
        }
    }

    public static void filterAndRetainLowestPriceProducts(Document doc) {
        System.out.println("Filtering products to retain only the lowest price for duplicates...");
        HashMap<String, Element> lowestPriceProducts = new HashMap<String, Element>();
        NodeList items = doc.getElementsByTagName("item");
        System.out.println("Total items before filtering: " + items.getLength());
        for (int i = 0; i < items.getLength(); ++i) {
            Element item = (Element)items.item(i);
            String productName = item.getElementsByTagName("title").item(0).getTextContent();
            if (productName.contains("-")) {
                productName = productName.split("-")[0].trim();
            }
            String priceText = item.getElementsByTagName("g:price").item(0).getTextContent();
            double price = Double.parseDouble(priceText.split(" ")[0].replace(",", ""));
            if (lowestPriceProducts.containsKey(productName) && !(price < Double.parseDouble(((Element)lowestPriceProducts.get(productName)).getElementsByTagName("g:price").item(0).getTextContent().split(" ")[0].replace(",", "")))) continue;
            lowestPriceProducts.put(productName, item);
        }
        System.out.println("Unique products after filtering: " + lowestPriceProducts.size());
        Element channel = (Element)doc.getElementsByTagName("channel").item(0);
        NodeList allItems = doc.getElementsByTagName("item");
        for (int i = allItems.getLength() - 1; i >= 0; --i) {
            Node parent = allItems.item(i).getParentNode();
            if (parent == null) continue;
            parent.removeChild(allItems.item(i));
        }
        for (Element item : lowestPriceProducts.values()) {
            Node importedNode = doc.importNode(item, true);
            channel.appendChild(importedNode);
        }
        System.out.println("Filtering completed. Retained " + lowestPriceProducts.size() + " items.");
    }

    public static void downloadAndResizeImages(NodeList imageNodes, String outputDir) {
        System.out.println("Starting image download and resize...");
        HashSet<String> processedImages = new HashSet<String>();
        for (int i = 0; i < imageNodes.getLength(); ++i) {
            Node node = imageNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String imageUrl = node.getTextContent();
            String fileName = imageUrl.substring(imageUrl.lastIndexOf(47) + 1);
            File outputImageFile = new File(outputDir + "/" + fileName);
            if (processedImages.contains(fileName) || outputImageFile.exists()) {
                System.out.println("Image already processed, skipping: " + outputImageFile.getAbsolutePath());
                continue;
            }
            try {
                System.out.println("Downloading image: " + imageUrl);
                URL url = new URL(imageUrl);
                BufferedImage originalImage = ImageIO.read(url);
                System.out.println("Resizing image to 800x800 pixels.");
                Image resizedImage = originalImage.getScaledInstance(800, 800, 4);
                BufferedImage bufferedResizedImage = new BufferedImage(800, 800, 1);
                Graphics2D g2d = bufferedResizedImage.createGraphics();
                g2d.drawImage(resizedImage, 0, 0, null);
                g2d.dispose();
                ImageIO.write((RenderedImage)bufferedResizedImage, "jpg", outputImageFile);
                processedImages.add(fileName);
                System.out.println("Image saved: " + outputImageFile.getAbsolutePath());
                continue;
            }
            catch (Exception e) {
                System.out.println("Error processing image: " + imageUrl);
                e.printStackTrace();
            }
        }
        System.out.println("Image download and resize completed.");
    }

    public static void updateXmlWithResizedLinks(Document doc, String outputDir) {
        System.out.println("Updating XML with new image links...");
        NodeList imageNodes = doc.getElementsByTagName("g:image_link");
        for (int i = 0; i < imageNodes.getLength(); ++i) {
            Node node = imageNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String oldUrl = node.getTextContent();
            String fileName = oldUrl.substring(oldUrl.lastIndexOf(47) + 1);
            String newUrl = "https://gsrc.fiszu.com/" + outputDir + "/" + fileName;
            node.setTextContent(newUrl);
            System.out.println("Updated link: " + newUrl);
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(outputDir + ".xml"));
            transformer.transform(source, result);
            System.out.println("XML updated successfully.");
        }
        catch (Exception e) {
            System.out.println("Error updating XML.");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String[][] inputArray;
        for (String[] input : inputArray = new String[][]{{"https://escooterclinic.co.uk/data/export/googleshoppinggb_107c7567a514fa3d2247e0a3.xml", "ESCGBPb2c"}, {"https://voltnation.pl/data/export/googleshoppingpl_3b548672e49c4b2684f1d837.xml", "VNPLNb2c"}}) {
            String url = input[0];
            String outputDir = input[1];
            if (new File(outputDir).mkdirs()) {
                System.out.println("Output directory created: " + outputDir);
            }
            System.out.println("Starting XML and image processing...");
            Document document = XmlFetcher.fetchXmlFromUrl(url);
            System.out.println(document);
            if (document != null) {
                XmlFetcher.filterAndRetainLowestPriceProducts(document);
                NodeList imageNodes = document.getElementsByTagName("g:image_link");
                XmlFetcher.downloadAndResizeImages(imageNodes, outputDir);
                XmlFetcher.updateXmlWithResizedLinks(document, outputDir);
                System.out.println("size of document: " + document.getElementsByTagName("item").getLength());
                System.out.println("XML and images processed successfully.");
                continue;
            }
            System.out.println("Failed to fetch or process XML.");
        }
    }
}

