/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class TestXmlSortingWithSAX {
    public static void main(String[] args) throws Exception {
        File xmlFile = new File("feed/escgbpb2c.xml");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        ScooterTestHandler handler = new ScooterTestHandler();
        System.out.println("Analyzing XML file: " + xmlFile.getAbsolutePath());
        saxParser.parse(xmlFile, (DefaultHandler)handler);
        System.out.println("\nAnalysis complete!");
        System.out.println("Total items processed: " + handler.getTotalCount());
        System.out.println("Scooters found: " + handler.getScooterCount());
        System.out.println("Non-scooters found: " + handler.getNonScooterCount());
        if (handler.isSortedCorrectly()) {
            System.out.println("\nSorting is CORRECT! All scooters appear before non-scooters.");
        } else {
            System.out.println("\nSorting is INCORRECT. Some scooters appear after non-scooters.");
            System.out.println("First non-scooter position: " + handler.getFirstNonScooterPos());
            System.out.println("First scooter after non-scooter position: " + handler.getIncorrectScooterPos());
        }
    }

    private static class ScooterTestHandler
    extends DefaultHandler {
        private int itemCount = 0;
        private int scooterCount = 0;
        private int nonScooterCount = 0;
        private boolean inItem = false;
        private boolean inTitle = false;
        private boolean inProductType = false;
        private StringBuilder currentTitle = new StringBuilder();
        private StringBuilder currentProductType = new StringBuilder();
        private boolean foundNonScooter = false;
        private boolean sortedCorrectly = true;
        private int firstNonScooterPos = -1;
        private int incorrectScooterPos = -1;

        private ScooterTestHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("item")) {
                this.inItem = true;
                ++this.itemCount;
                this.currentTitle = new StringBuilder();
                this.currentProductType = new StringBuilder();
            } else if (this.inItem && qName.equals("title")) {
                this.inTitle = true;
            } else if (this.inItem && qName.equals("g:product_type")) {
                this.inProductType = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.inTitle) {
                this.currentTitle.append(ch, start, length);
            } else if (this.inProductType) {
                this.currentProductType.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("item")) {
                this.inItem = false;
                String title = this.currentTitle.toString();
                String productType = this.currentProductType.toString();
                boolean isScooter = this.isScooterProduct(title, productType);
                if (this.itemCount <= 20) {
                    System.out.println(this.itemCount + ". " + title);
                    System.out.println("   Category: " + productType);
                    System.out.println("   Is Scooter: " + isScooter);
                    System.out.println();
                }
                if (isScooter) {
                    ++this.scooterCount;
                    if (this.foundNonScooter && this.sortedCorrectly) {
                        this.sortedCorrectly = false;
                        this.incorrectScooterPos = this.itemCount;
                    }
                } else {
                    ++this.nonScooterCount;
                    if (!this.foundNonScooter) {
                        this.foundNonScooter = true;
                        this.firstNonScooterPos = this.itemCount;
                    }
                }
            } else if (qName.equals("title")) {
                this.inTitle = false;
            } else if (qName.equals("g:product_type")) {
                this.inProductType = false;
            }
        }

        public int getTotalCount() {
            return this.itemCount;
        }

        public int getScooterCount() {
            return this.scooterCount;
        }

        public int getNonScooterCount() {
            return this.nonScooterCount;
        }

        public boolean isSortedCorrectly() {
            return this.sortedCorrectly;
        }

        public int getFirstNonScooterPos() {
            return this.firstNonScooterPos;
        }

        public int getIncorrectScooterPos() {
            return this.incorrectScooterPos;
        }

        private boolean isScooterProduct(String title, String category) {
            title = title.toLowerCase();
            category = category.toLowerCase();
            if (title.contains("scooter") || title.contains("e-scooter") || title.contains("electric scooter") || title.contains("escooter")) {
                return true;
            }
            if (category.contains("scooter") || category.contains("electric mobility")) {
                return true;
            }
            return title.contains("xiaomi") || title.contains("segway") || title.contains("ninebot") || title.contains("kugoo") || title.contains("inokim") || title.contains("kaabo") || title.contains("dualtron") || title.contains("apollo") || title.contains("etwow") || title.contains("brompton");
        }
    }
}

