/*
 * Decompiled with CFR 0.152.
 */
package main;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import main.Channel;
import main.Item;
import main.RssFeed;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Main {
    public static void main(String[] args) throws Exception {
        String[][] input = new String[][]{{"escooterclinic.co.uk", "esc", "English", "GBP", "b2c", "https://escooterclinic.co.uk/data/export/feed10002_198442e856d8630c35bca84b.xml", "escgbpb2c"}, {"b2b.escooterclinic.co.uk", "esc", "English", "GBP", "b2b", "https://b2b.escooterclinic.co.uk/data/export/feed10003_2f800a867c68da9b0c5fd0d3.xml", "escgbpb2b"}, {"voltnation.pl", "voltpl", "Polish", "PLN", "b2c", "https://voltnation.pl/data/export/feed10004_36149bb44a1aa1920a315444.xml", "voltplplnb2c"}, {"b2b.voltnation.pl", "volt", "Polish", "PLN", "b2b", "https://b2b.voltnation.pl/data/export/feed10005_40b57e44735479c7d1acb059.xml", "voltplnb2b"}, {"voltnation.de", "voltde", "German", "EUR", "b2c", "https://voltnation.de/data/export/feed10006_52f4c96b077b8fe423eb586e.xml", "voltdeeurb2c"}, {"voltnation.it", "voltit", "Italian", "EUR", "b2c", "https://voltnation.it/data/export/feed10008_74cd5c41420a4dfcb33231a7.xml", "voltiteurb2c"}, {"voltnation.es", "voltes", "Spanish", "EUR", "b2c", "https://voltnation.es/data/export/feed10009_8ddb673b867ca12ca0c4578f.xml", "volteseurb2c"}, {"voltnation.dk", "voltdk", "Danish", "DKK", "b2c", "https://voltnation.dk/data/export/feed10010_9c465d9a2a6d03e1c19fecb0.xml", "voltdkdkkb2c"}, {"voltnation.gr", "voltfgr", "Greek", "EUR", "b2c", "https://voltnation.gr/data/export/feed10011_102aac7295416efa1faf1ca56.xml", "voltfgreurb2c"}, {"voltnation.se", "voltse", "Swedish", "SEK", "b2c", "https://voltnation.se/data/export/feed10012_118343268d74f45905dbbd976.xml", "voltsesekb2c"}, {"voltnation.fi", "voltfi", "Finnish", "EUR", "b2c", "https://voltnation.fi/data/export/feed10013_124a45abc30a602ef2766c852.xml", "voltfieurb2c"}, {"voltnation.cz", "voltcz", "Czech", "CZK", "b2c", "https://voltnation.cz/data/export/feed10014_13b96050f0d36069ce236fe44.xml", "voltczczkb2c"}, {"voltnation.sk", "voltsk", "Slovak", "EUR", "b2c", "https://voltnation.sk/data/export/feed10015_14ae82cb44ed6a9da49a00b84.xml", "voltskeurb2c"}, {"voltnation.ro", "voltro", "Romanian", "RON", "b2c", "https://voltnation.ro/data/export/feed10016_1530d7aaf8a800042059d8e05.xml", "voltroronb2c"}, {"voltnation.pt", "voltpt", "Portuguese", "EUR", "b2c", "https://voltnation.pt/data/export/feed10017_1601621dc026d3948b3885132.xml", "voltpteurb2c"}, {"ebikeclinic.co.uk", "ebc", "English", "GBP", "b2c", "https://ebikeclinic.co.uk/data/export/feed10021_19d2c3f1e93d9ea3c47ccbeb0.xml", "ebcgbpb2c"}};
        HashSet<CallSite> productSignatures = new HashSet<CallSite>();
        ArrayList<Item> allProducts = new ArrayList<Item>();
        HashMap<String, List> checksumTitleToItems = new HashMap<String, List>();
        File outputDir = new File("feed");
        if (!outputDir.exists() && outputDir.mkdirs()) {
            System.out.println("Output directory created: " + String.valueOf(outputDir));
        }
        for (String[] siteInfo : input) {
            System.out.println("\nProcessing: " + siteInfo[0]);
            try {
                Document xmlDoc = Main.downloadAndParse(siteInfo[5]);
                if (xmlDoc == null) {
                    System.out.println("Failed to download or parse feed for: " + siteInfo[0]);
                    continue;
                }
                Element offer = (Element)xmlDoc.getChildNodes().item(0);
                NodeList products = offer.getChildNodes().item(1).getChildNodes();
                System.out.println("Total nodes in feed: " + products.getLength());
                int processedCount = 0;
                int skippedDuplicateCount = 0;
                for (int i = 0; i < products.getLength(); ++i) {
                    Node priceNode;
                    String afterHpeciai;
                    String[] subParts;
                    String[] parts;
                    Element imageLink;
                    Element smallImageNode;
                    Element product;
                    Element descriptionElement;
                    if (!products.item(i).getNodeName().equals("product") || (descriptionElement = (Element)(product = (Element)products.item(i)).getElementsByTagName("description").item(0)) == null) continue;
                    String id = product.getAttributes().getNamedItem("id").getNodeValue();
                    String globalId = siteInfo[1] + "-" + id;
                    String title = descriptionElement.getElementsByTagName("name").item(0).getTextContent();
                    String normalizedTitle = title.trim();
                    String checksum = "no_checksum";
                    String imageUrl = null;
                    Element imageNode = (Element)product.getElementsByTagName("images").item(0);
                    if (imageNode != null && (smallImageNode = (Element)imageNode.getElementsByTagName("icons").item(0)) != null && (imageLink = (Element)smallImageNode.getElementsByTagName("icon").item(0)) != null && (imageUrl = imageLink.getAttribute("url")).contains("/hpeciai/") && (parts = imageUrl.split("/hpeciai/")).length > 1 && (subParts = (afterHpeciai = parts[1]).split("/")).length > 0) {
                        checksum = subParts[0];
                    }
                    if ((priceNode = product.getElementsByTagName("price").item(0)) == null) continue;
                    String priceStr = priceNode.getAttributes().getNamedItem("gross").getNodeValue();
                    String normalizedPrice = priceStr.replace(",", "");
                    double price = Double.parseDouble(normalizedPrice);
                    Item item = new Item();
                    item.setId(globalId);
                    item.setTitle(title);
                    String desc = descriptionElement.getElementsByTagName("long_desc").item(0).getTextContent();
                    item.setDescription(desc);
                    Node categoryNode = product.getElementsByTagName("category").item(0);
                    String category = categoryNode.getAttributes().getNamedItem("name").getNodeValue();
                    if (category.equals("*Kategoria tymczasowa") || category.equals("Discontinued") || category.equals("Internal Items")) {
                        category = "No Category";
                    }
                    item.setProductType(category);
                    Node linkNode = product.getElementsByTagName("card").item(0);
                    String link = linkNode.getAttributes().getNamedItem("url").getNodeValue();
                    item.setLink(link);
                    if (imageUrl != null) {
                        item.setImageLink(imageUrl);
                    }
                    Element availabilityNode = (Element)product.getElementsByTagName("iaiext:visibility").item(0);
                    Element availabilityElement = (Element)availabilityNode.getElementsByTagName("iaiext:site").item(0);
                    String availability = availabilityElement.getAttributes().getNamedItem("visible").getNodeValue();
                    item.setAvailability(availability);
                    item.setPrice(priceStr + " " + siteInfo[3]);
                    Element gtinNode = (Element)product.getElementsByTagName("sizes").item(0);
                    if (gtinNode != null) {
                        Element gtinElement = (Element)gtinNode.getElementsByTagName("size").item(0);
                        if (gtinElement != null) {
                            Node gtinCodeElement = gtinElement.getAttributes().getNamedItem("code_producer");
                            if (gtinCodeElement != null) {
                                String gtin = gtinCodeElement.getNodeValue();
                                item.setGtin(gtin);
                            } else {
                                item.setGtin("No GTIN");
                            }
                        } else {
                            item.setGtin("No GTIN");
                        }
                    } else {
                        item.setGtin("No GTIN");
                    }
                    Node brandNode = product.getElementsByTagName("producer").item(0);
                    if (brandNode != null) {
                        String brand = brandNode.getAttributes().getNamedItem("name").getNodeValue();
                        item.setBrand(brand);
                    } else {
                        item.setBrand("No brand");
                    }
                    String productSignature = checksum + ":::" + normalizedTitle + ":::" + normalizedPrice;
                    if (productSignatures.contains(productSignature)) {
                        ++skippedDuplicateCount;
                        System.out.println("Skipping exact duplicate product: " + globalId);
                        continue;
                    }
                    productSignatures.add((CallSite)((Object)productSignature));
                    String checksumTitleKey = checksum + ":::" + normalizedTitle;
                    checksumTitleToItems.computeIfAbsent(checksumTitleKey, k -> new ArrayList()).add(item);
                    ++processedCount;
                }
                System.out.println("Processed products: " + processedCount);
                System.out.println("Skipped exact duplicates: " + skippedDuplicateCount);
            }
            catch (Exception e) {
                System.out.println("Error processing " + siteInfo[0] + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        for (List items : checksumTitleToItems.values()) {
            if (items.size() == 1) {
                allProducts.add((Item)items.get(0));
                continue;
            }
            allProducts.addAll(items);
        }
        System.out.println("\nTotal unique products: " + allProducts.size());
        ArrayList<Item> scooterProducts = new ArrayList<Item>();
        ArrayList<Item> nonScooterProducts = new ArrayList<Item>();
        for (Item item : allProducts) {
            boolean isScooterItem = Main.isScooter(item);
            if (isScooterItem) {
                scooterProducts.add(item);
                continue;
            }
            nonScooterProducts.add(item);
        }
        System.out.println("Scooter products: " + scooterProducts.size());
        System.out.println("Non-scooter products: " + nonScooterProducts.size());
        RssFeed combinedFeed = new RssFeed();
        Channel channel = new Channel();
        combinedFeed.setChannel(channel);
        for (Item item : scooterProducts) {
            combinedFeed.addItem(item);
        }
        for (Item item : nonScooterProducts) {
            combinedFeed.addItem(item);
        }
        System.out.println("Final feed size: " + combinedFeed.getItems().size());
        try {
            JAXBContext context = JAXBContext.newInstance(RssFeed.class);
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", true);
            File combinedFile = new File("feed/combined_feed.xml");
            marshaller.marshal((Object)combinedFeed, combinedFile);
            System.out.println("Combined feed created: " + combinedFile.getAbsolutePath());
        }
        catch (JAXBException e) {
            System.out.println("Error creating combined feed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static boolean isScooter(Item item) {
        String title = item.getTitle().toLowerCase();
        if (title.contains("scooter") || title.contains("e-scooter") || title.contains("electric scooter") || title.contains("escooter")) {
            return true;
        }
        String category = item.getProductType().toLowerCase();
        if (category.contains("scooter") || category.contains("electric mobility")) {
            return true;
        }
        return title.contains("xiaomi") || title.contains("segway") || title.contains("ninebot") || title.contains("kugoo") || title.contains("inokim") || title.contains("kaabo") || title.contains("dualtron") || title.contains("apollo") || title.contains("etwow") || title.contains("brompton");
    }

    private static Document downloadAndParse(String urlString) throws Exception {
        try {
            URL url = new URI(urlString).toURL();
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(60000);
            InputStream inputStream = connection.getInputStream();
            String body = new String(inputStream.readAllBytes());
            inputStream.close();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(body.getBytes()));
        }
        catch (IOException e) {
            System.out.println("Error downloading or parsing " + urlString + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

